/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.ui.internal.views.AbstractLinkedSonarWebView;

public class RuleDescriptionWebView
extends AbstractLinkedSonarWebView<IMarker>
implements ISelectionListener {
    public static final String ID = "org.sonarlint.eclipse.ui.views.RuleDescriptionWebView";
    private static final String CSS = "<style type=\"text/css\">body { font-family: Helvetica Neue,Segoe UI,Helvetica,Arial,sans-serif; font-size: 13px; line-height: 1.23076923;}h1 { color: #444;font-size: 14px;font-weight: 500; }h2 { line-height: 24px; color: #444;}a { border-bottom: 1px solid #cae3f2; color: #236a97; cursor: pointer; outline: none; text-decoration: none; transition: all .2s ease;}.rule-desc { line-height: 1.5;}.rule-desc { line-height: 1.5;}.rule-desc h2 { font-size: 16px; font-weight: 400;}.rule-desc code { padding: .2em .45em; margin: 0; background-color: rgba(0,0,0,.04); border-radius: 3px; white-space: nowrap;}.rule-desc pre { padding: 10px; border-top: 1px solid #e6e6e6; border-bottom: 1px solid #e6e6e6; line-height: 18px; overflow: auto;}.rule-desc code, .rule-desc pre { font-family: Consolas,Liberation Mono,Menlo,Courier,monospace; font-size: 12px;}.rule-desc ul { padding-left: 40px; list-style: disc;}</style>";

    @Override
    protected void open(IMarker element) {
        try {
            String htmlDescription;
            String ruleName = element.getAttribute("rulename").toString();
            String ruleKey = element.getAttribute("rulekey").toString();
            SonarLintProject p = SonarLintProject.getInstance((IResource)element.getResource());
            if (StringUtils.isBlank((String)p.getServerId())) {
                htmlDescription = SonarLintCorePlugin.getDefault().getDefaultSonarLintClientFacade().getHtmlRuleDescription(ruleKey);
            } else {
                IServer server = ServersManager.getInstance().getServer(p.getServerId());
                if (server == null) {
                    super.showMessage("Project " + p.getProject().getName() + " is linked to an unknown server: " + p.getServerId() + ". Please update configuration.");
                    return;
                }
                htmlDescription = server.getHtmlRuleDescription(ruleKey);
            }
            super.showHtml("<!doctype html><html><head><style type=\"text/css\">body { font-family: Helvetica Neue,Segoe UI,Helvetica,Arial,sans-serif; font-size: 13px; line-height: 1.23076923;}h1 { color: #444;font-size: 14px;font-weight: 500; }h2 { line-height: 24px; color: #444;}a { border-bottom: 1px solid #cae3f2; color: #236a97; cursor: pointer; outline: none; text-decoration: none; transition: all .2s ease;}.rule-desc { line-height: 1.5;}.rule-desc { line-height: 1.5;}.rule-desc h2 { font-size: 16px; font-weight: 400;}.rule-desc code { padding: .2em .45em; margin: 0; background-color: rgba(0,0,0,.04); border-radius: 3px; white-space: nowrap;}.rule-desc pre { padding: 10px; border-top: 1px solid #e6e6e6; border-bottom: 1px solid #e6e6e6; line-height: 18px; overflow: auto;}.rule-desc code, .rule-desc pre { font-family: Consolas,Liberation Mono,Menlo,Courier,monospace; font-size: 12px;}.rule-desc ul { padding-left: 40px; list-style: disc;}</style></head><body><h1><big>" + ruleName + "</big> (" + ruleKey + ")</h1><div class=\"rule-desc\">" + htmlDescription + "</div></body></html>");
        }
        catch (CoreException e) {
            SonarLintCorePlugin.getDefault().error("Unable to open rule description", (Throwable)e);
        }
    }

    @Override
    protected IMarker findSelectedElement(IWorkbenchPart part, ISelection selection) {
        return this.findSelectedSonarIssue(part, selection);
    }
}

